/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.UserRoleProperties;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UserRole
extends HwmcaObject
implements UserRoleProperties {
    ObjectId basedOnRole = null;
    private Set permittedObjects;
    boolean isDisplayable;
    boolean isEditable;
    public static final int TYPE_MO = 0;
    public static final int TYPE_TASK = 1;
    public static final int TYPE_ROLE = 2;
    private static final ClassId[] USER_ROLE_CLASSID = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$UserRole == null ? (class$com$ibm$hwmca$fw$managed$UserRole = UserRole.class$("com.ibm.hwmca.fw.managed.UserRole")) : class$com$ibm$hwmca$fw$managed$UserRole)};
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "User");
    private static final String TRACE_MASKT = "XFRMUSRT";
    private static final String TRACE_MASKF = "XFRMUSRF";
    private static final String TRACE_MASKD = "XFRMUSRD";
    private int _type;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$UserRole;

    public UserRole(String name, UIInfo uiInfo) {
        ObjectId id = new ObjectId(this);
        if (name != null) {
            id.setKeyProperty("Name", name);
        }
        this.setObjectId(id);
        this.uiInfo = uiInfo;
        this.permittedObjects = new HashSet();
        this._type = 0;
        this.basedOnRole = null;
    }

    public UserRole(PersistentData data, String persistKey) {
        super(((Persistent)data).parentData, persistKey);
        if (this.getClass().equals(class$com$ibm$hwmca$fw$managed$UserRole == null ? (class$com$ibm$hwmca$fw$managed$UserRole = UserRole.class$("com.ibm.hwmca.fw.managed.UserRole")) : class$com$ibm$hwmca$fw$managed$UserRole)) {
            Trace.trace(TRACE_MASKT, "<> UserRole (data=" + data + ", persistKey=" + persistKey + ")");
        }
        this.permittedObjects = ((Persistent)data).permittedObjects;
        this.basedOnRole = ((Persistent)data).basedOnRole != null ? new ObjectId(((Persistent)data).basedOnRole) : null;
        this._type = ((Persistent)data).type;
        this.isDisplayable = ((Persistent)data).isDisplayable;
        this.isEditable = ((Persistent)data).isEditable;
    }

    public String getName() {
        String result = (String)this.getObjectId().getKeyProperty("Name");
        if (result == null) {
            result = "";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPermittedObjects() {
        Set set = this.permittedObjects;
        synchronized (set) {
            return this.permittedObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermittedObject(ClassId newObject) {
        if (newObject != null) {
            Set set = this.permittedObjects;
            synchronized (set) {
                this.permittedObjects.add(newObject);
            }
        }
        this.autoPersist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermittedObjects(Collection newObjects) {
        if (newObjects != null) {
            Set set = this.permittedObjects;
            synchronized (set) {
                this.permittedObjects.addAll(newObjects);
            }
        }
        this.autoPersist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermittedObjects(Set newObjects) {
        Set set = this.permittedObjects;
        synchronized (set) {
            this.permittedObjects.clear();
            this.permittedObjects.addAll(newObjects);
        }
        this.autoPersist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectPermitted(ObjectId objectId) {
        boolean result = false;
        Set set = this.permittedObjects;
        synchronized (set) {
            result = this.permittedObjects.contains(objectId);
            if (!result) {
                result = this.permittedObjects.contains(objectId.getClassId());
            }
        }
        return result;
    }

    public boolean isDisplayable() {
        return this.isDisplayable;
    }

    public void setDisplayable(boolean displayFlag) {
        this.isDisplayable = displayFlag;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean editFlag) {
        this.isEditable = editFlag;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.permittedObjects = (HashSet)this.permittedObjects;
        if (this.basedOnRole != null) {
            result.basedOnRole = this.basedOnRole.toString();
        }
        result.type = this._type;
        result.isDisplayable = this.isDisplayable;
        result.isEditable = this.isEditable;
        return result;
    }

    public void setType(int type) {
        this._type = type;
    }

    public int getType() {
        return this._type;
    }

    public boolean isManagedObjectRole() {
        return this.getType() == 0;
    }

    public boolean isTaskRole() {
        return this.getType() == 1;
    }

    public static UserRole getBaseRole(int mode) {
        String role;
        switch (mode) {
            case 0: {
                role = "base.rolegroup.pedebug";
                break;
            }
            case 1: {
                role = "base.rolegroup.service";
                break;
            }
            case 2: {
                role = "base.rolegroup.sysprog";
                break;
            }
            case 3: {
                role = "base.rolegroup.advanced";
                break;
            }
            case 4: {
                role = "base.rolegroup.operator";
                break;
            }
            default: {
                role = "base.rolegroup.acsadmin";
            }
        }
        return UserRole.getRole(role);
    }

    public static UserRole getRole(String role) {
        Set inventory = HwmcaObject.mom.getInventoryObjectIds(USER_ROLE_CLASSID);
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            ObjectId objId = (ObjectId)iterator.next();
            String key = (String)objId.getKeyProperty("Name");
            if (key.equals(role)) {
                return (UserRole)HwmcaObject.mom.get(objId);
            }
            UserRole curRole = (UserRole)HwmcaObject.mom.get(objId);
            if (curRole.getUIInfo().getName().equals(role)) {
                return curRole;
            }
            if (!curRole.getUIInfo().getTitle().equals(role)) continue;
            return curRole;
        }
        return null;
    }

    public ObjectId getBasedOnRole() {
        return this.basedOnRole;
    }

    public void setBasedOnRole(ObjectId baseRole) {
        this.basedOnRole = baseRole;
        this.autoPersist();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Persistent
    implements PersistentData {
        int version = 0;
        PersistentData parentData;
        HashSet permittedObjects;
        String basedOnRole;
        int type;
        boolean isDisplayable;
        boolean isEditable;
        private static final long serialVersionUID = 4103056583246736043L;

        private Persistent() {
        }
    }
}

